/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.deploy.DeployPlugin;
import com.aptana.deploy.internal.ProjectPropertyTester;
import com.aptana.deploy.preferences.IPreferenceConstants;
import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class DeployPreferenceUtil {
    private static final String DEPLOY_PLUGIN_IDENTIFIER = DeployPlugin.getPluginIdentifier();
    private static final QualifiedName DEPLOY_TYPE_QUALIFIED_KEY = new QualifiedName(DEPLOY_PLUGIN_IDENTIFIER, "provider");
    private static final String RED_HAT_STRING = IPreferenceConstants.DeployType.RED_HAT.toString();
    private static final String ENGINEYARD_STRING = IPreferenceConstants.DeployType.ENGINEYARD.toString();
    private static final String CAPISTRANO_STRING = IPreferenceConstants.DeployType.CAPISTRANO.toString();
    private static final String FTP_STRING = IPreferenceConstants.DeployType.FTP.toString();
    private static final String HEROKU_STRING = IPreferenceConstants.DeployType.HEROKU.toString();
    private static IPreferencesService preferencesService = Platform.getPreferencesService();

    private static IPreferenceConstants.DeployType getDeployType(IProject project) {
        if (project == null) {
            return IPreferenceConstants.DeployType.NONE;
        }
        String projectName = project.getName();
        String key = new StringBuilder("ProjectDeployType".length() + projectName.length() + 2).append("ProjectDeployType").append(':').append(projectName).toString();
        String type = preferencesService.getString(DEPLOY_PLUGIN_IDENTIFIER, key, null, null);
        if (type != null) {
            if (type.equals(HEROKU_STRING)) {
                return IPreferenceConstants.DeployType.HEROKU;
            }
            if (type.equals(FTP_STRING)) {
                return IPreferenceConstants.DeployType.FTP;
            }
            if (type.equals(CAPISTRANO_STRING)) {
                return IPreferenceConstants.DeployType.CAPISTRANO;
            }
            if (type.equals(ENGINEYARD_STRING)) {
                return IPreferenceConstants.DeployType.ENGINEYARD;
            }
            if (type.equals(RED_HAT_STRING)) {
                return IPreferenceConstants.DeployType.RED_HAT;
            }
        }
        return IPreferenceConstants.DeployType.NONE;
    }

    public static String getDeployEndpoint(IContainer container) {
        if (container == null) {
            return null;
        }
        return Platform.getPreferencesService().getString(DEPLOY_PLUGIN_IDENTIFIER, MessageFormat.format("{0}:{1}", "ProjectDeployEndpoint", container.getFullPath()), null, null);
    }

    public static String getDeployProviderId(IContainer container) {
        if (container == null) {
            return null;
        }
        String id = null;
        try {
            id = container.getProject().getPersistentProperty(DEPLOY_TYPE_QUALIFIED_KEY);
            if (id == null) {
                id = DeployPreferenceUtil.mapTypeToId(DeployPreferenceUtil.getDeployType(container.getProject()));
            }
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)DeployPlugin.getDefault(), (Throwable)e);
        }
        return id;
    }

    private static String mapTypeToId(IPreferenceConstants.DeployType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case RED_HAT: {
                return "com.aptana.deploy.redhat.provider";
            }
            case HEROKU: {
                return "com.aptana.deploy.heroku.provider";
            }
            case ENGINEYARD: {
                return "com.aptana.deploy.engineyard.provider";
            }
            case FTP: {
                return "com.aptana.deploy.ftp.provider";
            }
            case CAPISTRANO: {
                return "com.aptana.deploy.capistrano.provider";
            }
        }
        return null;
    }

    public static void setDeployType(IContainer container, String providerId) {
        try {
            container.getProject().setPersistentProperty(DEPLOY_TYPE_QUALIFIED_KEY, providerId);
            ProjectPropertyTester.resetCache(container);
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)DeployPlugin.getDefault(), (Throwable)e);
        }
    }

    public static void setDeployEndpoint(IContainer container, String endpoint) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(DEPLOY_PLUGIN_IDENTIFIER);
        prefs.put(MessageFormat.format("{0}:{1}", "ProjectDeployEndpoint", container.getFullPath()), endpoint);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logWarning((Plugin)DeployPlugin.getDefault(), (Throwable)e);
        }
    }
}

